﻿/*
VERSION: 	1.0

USAGE:
	#include "functions/asyncLoop.as"
	var loopDone_prom = asyncLoop( 0, 100, eachTime_func, true );
	loopDone_prom.then( done_func );
	
	var loopDone_prom = asyncLoop({
		from: 0,
		to: 100,
		eachTime: eachTime_func,
		waitForEach: true
	});
	
	function eachTime_func( i, loopDone_prom ){
		trace("loop "+i);
		if(i === 50){
			trace("  Testing pause()");
			loopDone_prom.pause();
			setTimeout(function(){
				trace("  Calling resume()");
				loopDone_prom.resume();
			}, 1000);
		}// if:  index = 50
		return VOW.firstWait(0);
	}// eachTime()

DESCRIPTION:
	This loop will run as fast as the slowest syncronous step
*/
function asyncLoop(from, to, eachTime, waitForEach){
	#include "VOW.as"
	// params as an object
	if( typeof(arguments[0]) === "object" ){
		var from = arguments[0].from;
		var to = (to===undefined) ? arguments[0].to : to;
		var eachTime = (eachTime===undefined) ? arguments[0].eachTime : eachTime;
		var waitForEach = (waitForEach===undefined) ? arguments[0].waitForEach : waitForEach;
	}// if:  params were passed in an object
	
	// optional params
	if(waitForEach===undefined)		var waitForEach = false;
	if(to===undefined)		var to = 0;
	
	var vow = VOW.make();
	var isPaused = false;
	var delayThresh = 18;
	var loadDelay = 0;
	var maxLoadDelay = 200;
	var minDelay = 0;
	var promDelay = 0;
	if(from !== to){
		var dir = (to-from) / Math.abs(to-from);
	}else{
		var dir = 1;
	}
	// performance automatic self-adjustments
	var runDelay = 0;
	var measureFrom = getTimer();
	
	var index = from;
	function doLoop(){
		if(index === to){			vow.keep();		trace("loadDelay: "+loadDelay);			return;		}
		// adjust performance
		if( loadDelay < maxLoadDelay ){
			var measureTo = getTimer();
			var diff = (measureTo - measureFrom);
			measureFrom = measureTo;
			if(diff-promDelay-delayThresh > loadDelay)	loadDelay = diff-promDelay;
		}// if:  not at slowest speed
		else if( loadDelay > maxLoadDelay ){
			loadDelay = minDelay;
		}// if:  too slow
		
		var result = eachTime( index, vow.promise );
		index += dir;
		
		if(waitForEach && result.is_promise){
			// wait for promise,  then wait,  then run the next loop
			var promDelay_start = getTimer();
			result.then( function(){
				promDelay = getTimer() - promDelay_start;
				repeat();
			} );
		}else{
			// wait,  then run the next loop
			promDelay = 0;
			repeat();
		}
		
		function repeat(){
			if(isPaused)		return;
			
			if(loadDelay === 0){
				// allow fast functions to run synchronously
				doLoop();
			}else{
				setTimeout( function(){
					doLoop();
				}, loadDelay );		// give the progress bar a chance to update
			}
		}// repeat()
	}// doLoop()
	
	function pause(){
		isPaused = true;
	}// pause()
	
	function resume(){
		if(isPaused===false)	return;
		isPaused = false;
		// ignore this delay when you do the next performance measurement
		measureFrom = getTimer();
		doLoop();
	}// resume()
	
	vow.promise.pause = pause;
	vow.promise.resume = resume;
	
	// allow pause() and resume() to be returned first,  then begin the loop
	setTimeout(function(){
		doLoop();
	}, 0);
	
	return vow.promise;
}// asyncLoop()
